<?php
/* --------------------------------------------------------------
  StyleThemeControl.php 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

namespace StyleEdit;

/**
 * Class StyleEditThemeControl
 *
 * This class will resolve various StyleEdit3 related paths, depending on whether the shop is using a theme or
 * a template.
 * 
 * Important: Ensure that all paths returned by the class contain a trailing slash. 
 *
 * @package StyleEdit
 */
class StyleThemeControl
{
	/**
	 * Returns true if the user modifies a theme.
	 *
	 * @return bool
	 */
	public static function isThemeSystemActive()
	{
		return isset($_REQUEST['theme']);
	}
	
	
	/**
	 * Get styles directory path.
	 *
	 * @param string $p_currentTemplate
	 *
	 * @return string
	 */
	public static function getStylesDirectoryPath($p_currentTemplate)
	{
		return self::isThemeSystemActive() ? __DIR__ . '/../../public/theme/styles/styleedit/' : __DIR__
		                                                                                        . '/../templates/'
		                                                                                        . $p_currentTemplate . '/';
	}
	
	
	/**
	 * Get original theme styles directory path.
	 *
	 * @param string $p_currentTemplate
	 *
	 * @return string
	 */
	public static function getOriginalThemeStylesDirectoryPath($p_currentTemplate)
	{
		return __DIR__ . '/../../themes/' . $p_currentTemplate . '/styles/styleedit/';
	}
	
	
	/**
	 * Get images directory.
	 *
	 * @param string $p_currentTemplate Current template name.
	 *
	 * @return string
	 */
	public static function getImagesDirectory($p_currentTemplate)
	{
		return self::isThemeSystemActive() ? 'public/theme/images/custom/' : 'templates/' . $p_currentTemplate
		                                                                     . '/assets/images/custom/';
	}
	
	
	/**
	 * Get images directory path.
	 *
	 * @param string $p_currentTemplate Current template name.
	 *
	 * @return string
	 */
	public static function getImagesDirectoryPath($p_currentTemplate)
	{
		return self::isThemeSystemActive() ? '/../public/theme/images/custom/' : '/../templates/' . $p_currentTemplate
		                                                                         . '/assets/images/custom/';
	}
	
	
	/**
	 * Get original theme images directory path.
	 *
	 * @param string $p_currentTemplate
	 *
	 * @return string
	 */
	public static function getOriginalThemeImagesDirectoryPath($p_currentTemplate)
	{
		return __DIR__ . '/../../themes/' . $p_currentTemplate . '/images/custom/';
	}
}
